<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('questionnaire_id', 'slug', 'libelle', 'statut');
    protected $visible = array('questionnaire_id', 'slug', 'libelle', 'statut');

    public function questionnaire()
    {
        return $this->belongsTo('App\Models\Questionnaire', 'questionnaire_id');
    }

    public function reponseQuestion()
    {
        return $this->hasMany('App\Models\ReponseQuestion', 'question_id');
    }

}